//static void mean(String daten) throws FileNotFoundException {
//   var diso = new DataInputStream(new FileInputStream(daten));
//    try (DataInputStream dis = diso) {
//        double sum = 0.0;
//        int n = 0;
//        while (dis.available() > 0) {
//            n++;
//            sum += dis.readDouble();
//        }
//        IO.println("Mittelwert zur Datei " + daten + ":  " + sum / n);
//    } catch (IOException ioe) {
//        ioe.printStackTrace();
//    }
//}

static void mean(String daten) throws FileNotFoundException {
    var diso = new DataInputStream(new FileInputStream(daten));
    try (diso) {
        double sum = 0.0;
        int n = 0;
        while (diso.available() > 0) {
            n++;
            sum += diso.readDouble();
        }
        IO.println("Mittelwert zur Datei " + daten + ":  " + sum / n);
    } catch (IOException ioe) {
        ioe.printStackTrace();
    }
}

static void mean2(DataInputStream dis) {
    try (dis) {
        double sum = 0.0;
        int n = 0;
        while (dis.available() > 0) {
            n++;
            sum += dis.readDouble();
        }
        IO.println("Mittelwert: " + sum / n);
    } catch (IOException ioe) {
        ioe.printStackTrace();
    }
}

static void createData(String daten) {
    try (var dos = new DataOutputStream(new FileOutputStream(daten))) {
        Random ran = new Random();
        for (int i = 1; i <= 100; i++)
            dos.writeDouble(ran.nextDouble());
    } catch (IOException ioe) {
        ioe.printStackTrace();
    }
}

void main() throws FileNotFoundException {
    createData("eingabe.dat");
    mean("eingabe.dat");
    var dis = new DataInputStream(new FileInputStream("eingabe.dat"));
    mean2(dis);
}